/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles.optional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.launcher.base.profiles.optional.OptionalView$OptionalFileInstallInfo;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;

public class OptionalView {
    public Set<OptionalFile> enabled = new HashSet<OptionalFile>();
    public Map<OptionalFile, OptionalView$OptionalFileInstallInfo> installInfo = new HashMap<OptionalFile, OptionalView$OptionalFileInstallInfo>();
    public Set<OptionalFile> all;

    public OptionalView(ClientProfile clientProfile) {
        this.all = clientProfile.getOptional();
        for (OptionalFile optionalFile : this.all) {
            if (!optionalFile.mark) continue;
            this.enable(optionalFile, true, null);
        }
    }

    public OptionalView(OptionalView optionalView) {
        this.enabled = new HashSet<OptionalFile>(optionalView.enabled);
        this.installInfo = new HashMap<OptionalFile, OptionalView$OptionalFileInstallInfo>(optionalView.installInfo);
        this.all = optionalView.all;
        this.fixDependencies();
    }

    public OptionalView(ClientProfile clientProfile, OptionalView optionalView) {
        this(clientProfile);
        for (OptionalFile optionalFile2 : optionalView.all) {
            OptionalFile optionalFile3 = this.findByName(optionalFile2.name);
            if (optionalFile3 == null) continue;
            if (optionalView.isEnabled(optionalFile2)) {
                this.enable(optionalFile3, optionalView.installInfo.get((Object)optionalFile2).isManual, (optionalFile, bl) -> {});
                continue;
            }
            this.disable(optionalFile3, (optionalFile, bl) -> {});
        }
        this.fixDependencies();
    }

    public <T extends OptionalAction> Set<T> getActionsByClass(Class<T> clazz) {
        HashSet<OptionalAction> hashSet = new HashSet<OptionalAction>();
        for (OptionalFile optionalFile : this.enabled) {
            if (optionalFile.actions == null) continue;
            for (OptionalAction optionalAction : optionalFile.actions) {
                if (!clazz.isAssignableFrom(optionalAction.getClass())) continue;
                hashSet.add(optionalAction);
            }
        }
        return hashSet;
    }

    public OptionalFile findByName(String string) {
        for (OptionalFile optionalFile : this.all) {
            if (!string.equals(optionalFile.name)) continue;
            return optionalFile;
        }
        return null;
    }

    public boolean isEnabled(OptionalFile optionalFile) {
        return this.enabled.contains(optionalFile);
    }

    public Set<OptionalAction> getEnabledActions() {
        HashSet<OptionalAction> hashSet = new HashSet<OptionalAction>();
        for (OptionalFile optionalFile : this.enabled) {
            if (optionalFile.actions == null) continue;
            hashSet.addAll(optionalFile.actions);
        }
        return hashSet;
    }

    public void fixDependencies() {
        Set set = this.all.stream().filter(optionalFile -> !this.isEnabled((OptionalFile)optionalFile)).collect(Collectors.toSet());
        for (OptionalFile optionalFile2 : set) {
            if (optionalFile2.group == null || !Arrays.stream(optionalFile2.group).noneMatch(this::isEnabled)) continue;
            this.enable(optionalFile2.group[0], false, null);
        }
        for (OptionalFile optionalFile2 : this.enabled) {
            if (optionalFile2.dependencies != null) {
                for (OptionalFile optionalFile3 : optionalFile2.dependencies) {
                    this.enable(optionalFile3, false, null);
                }
            }
            if (optionalFile2.conflict != null) {
                for (OptionalFile optionalFile3 : optionalFile2.conflict) {
                    this.disable(optionalFile3, null);
                }
            }
            if (optionalFile2.group == null) continue;
            for (OptionalFile optionalFile3 : optionalFile2.group) {
                this.disable(optionalFile3, null);
            }
        }
    }

    public Set<OptionalAction> getDisabledActions() {
        HashSet<OptionalAction> hashSet = new HashSet<OptionalAction>();
        for (OptionalFile optionalFile : this.all) {
            if (this.enabled.contains(optionalFile) || optionalFile.actions == null) continue;
            hashSet.addAll(optionalFile.actions);
        }
        return hashSet;
    }

    public void enable(OptionalFile optionalFile2, boolean bl, BiConsumer<OptionalFile, Boolean> biConsumer) {
        if (this.enabled.contains(optionalFile2)) {
            return;
        }
        this.enabled.add(optionalFile2);
        if (biConsumer != null) {
            biConsumer.accept(optionalFile2, true);
        }
        OptionalView$OptionalFileInstallInfo optionalView$OptionalFileInstallInfo = this.installInfo.computeIfAbsent(optionalFile2, optionalFile -> new OptionalView$OptionalFileInstallInfo());
        optionalView$OptionalFileInstallInfo.isManual = bl;
        if (optionalFile2.dependencies != null) {
            for (OptionalFile optionalFile3 : optionalFile2.dependencies) {
                this.enable(optionalFile3, false, biConsumer);
            }
        }
        if (optionalFile2.conflict != null) {
            for (OptionalFile optionalFile3 : optionalFile2.conflict) {
                this.disable(optionalFile3, biConsumer);
            }
        }
        if (optionalFile2.group != null) {
            for (OptionalFile optionalFile3 : optionalFile2.group) {
                this.disable(optionalFile3, biConsumer);
            }
        }
    }

    public void disable(OptionalFile optionalFile, BiConsumer<OptionalFile, Boolean> biConsumer) {
        if (!this.enabled.remove(optionalFile)) {
            return;
        }
        if (biConsumer != null) {
            biConsumer.accept(optionalFile, false);
        }
        for (OptionalFile optionalFile2 : this.all) {
            if (optionalFile2.dependencies == null || !this.contains(optionalFile, optionalFile2.dependencies)) continue;
            this.disable(optionalFile2, biConsumer);
        }
        if (optionalFile.dependencies != null) {
            for (OptionalFile optionalFile3 : optionalFile.dependencies) {
                OptionalView$OptionalFileInstallInfo optionalView$OptionalFileInstallInfo = this.installInfo.get(optionalFile3);
                if (optionalView$OptionalFileInstallInfo == null || optionalView$OptionalFileInstallInfo.isManual) continue;
                this.disable(optionalFile, biConsumer);
            }
        }
        if (optionalFile.group != null && optionalFile.group.length != 0 && Arrays.stream(optionalFile.group).noneMatch(this::isEnabled)) {
            this.enable(optionalFile.group[0], false, biConsumer);
        }
    }

    private boolean contains(OptionalFile optionalFile, OptionalFile[] optionalFileArray) {
        for (OptionalFile optionalFile2 : optionalFileArray) {
            if (optionalFile2 != optionalFile) continue;
            return true;
        }
        return false;
    }
}

