/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.enfs.dir.Directory;
import pro.gravit.utils.enfs.dir.FileEntry;
import pro.gravit.utils.enfs.dir.MemoryFile;
import pro.gravit.utils.enfs.dir.URLFile;
import pro.gravit.utils.enfs.impl.EnFSURLStreamHandlerProvider;

public final class EnFS {
    public static final DebugOutput NULL_DEBUG_OUTPUT = new DebugOutput(){

        @Override
        public void debug(String str) {
        }

        @Override
        public void debug(String format, Object ... args) {
        }
    };
    public static volatile DebugOutput DEBUG_OUTPUT;
    public static final EnFS main;
    private static final Map<String, EnFS> map;
    private final Directory root = new Directory();
    private final String name;

    private EnFS(String name) {
        this.name = name;
    }

    public static EnFS getByName(String name) {
        if (name == null || name.isEmpty()) {
            return main;
        }
        return map.get(name);
    }

    public static EnFS newInstance(String name) {
        DEBUG_OUTPUT.debug("newInstance %s", name);
        if (map.containsKey(name)) {
            return map.get(name);
        }
        return map.put(name, new EnFS(name));
    }

    public FileEntry getFile(Path path) {
        DEBUG_OUTPUT.debug("Open %s", path.toString());
        return this.root.find(path);
    }

    public final void newDirectory(Path path) throws IOException {
        DEBUG_OUTPUT.debug("newDirectory %s", path.toString());
        this.addFile(path, new Directory());
    }

    public final void newDirectories(Path path) {
        if (path == null) {
            return;
        }
        DEBUG_OUTPUT.debug("newDirectories %s", path.toString());
        Directory current = this.root;
        for (Path p : path) {
            Directory entity = (Directory)current.get(p.toString());
            if (entity == null) {
                entity = new Directory();
                current.add(p.toString(), entity);
            }
            current = entity;
        }
    }

    public final void delete(Path path) throws IOException {
        DEBUG_OUTPUT.debug("delete %s", path.toString());
        FileEntry entry = this.root.find(path.getParent());
        if (entry == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
        if (entry == this.root) {
            throw new SecurityException("Root / can't delete");
        }
        if (((Directory)entry).delete(path.getFileName().toString()) == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
    }

    public final InputStream getInputStream(Path path) throws IOException {
        DEBUG_OUTPUT.debug("getInputStream %s", path.toString());
        FileEntry entry = this.root.find(path);
        if (entry == null) {
            throw new FileNotFoundException(String.format("File %s not found", path));
        }
        return entry.getInputStream();
    }

    public final void addFile(Path path, FileEntry file) throws IOException {
        FileEntry entry = this.root.find(path.getParent());
        if (entry == null) {
            throw new FileNotFoundException(String.format("Directory %s not found", path.getParent()));
        }
        if (!(entry instanceof Directory)) {
            throw new IOException(String.format("%s is not directory", path.getParent()));
        }
        ((Directory)entry).add(path.getFileName().toString(), file);
    }

    public final void addFile(Path path, byte[] bytes) throws IOException {
        this.addFile(path, new MemoryFile(bytes));
    }

    public final void addFile(Path path, URL url) throws IOException {
        this.addFile(path, new URLFile(url));
    }

    public final URL getURL(Path path) throws IOException {
        URL uRL;
        block8: {
            InputStream stream = this.getInputStream(Paths.get(this.name, new String[0]));
            try {
                uRL = new URL("enfs", null, -1, this.name);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedOperationException ex) {
                    throw new FileNotFoundException(this.name);
                }
            }
            stream.close();
        }
        return uRL;
    }

    public final void clear() {
        this.root.clear();
    }

    static {
        URL.setURLStreamHandlerFactory(new EnFSURLStreamHandlerProvider());
        DEBUG_OUTPUT = NULL_DEBUG_OUTPUT;
        main = new EnFS("");
        map = new ConcurrentHashMap<String, EnFS>();
    }

    public static interface DebugOutput {
        public void debug(String var1);

        public void debug(String var1, Object ... var2);
    }
}

