/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs.dir;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import pro.gravit.utils.enfs.dir.FileEntry;

public class CachedFile
extends FileEntry {
    private final FileEntry delegate;
    private volatile SoftReference<byte[]> cache;

    public CachedFile(FileEntry delegate) {
        this.delegate = delegate;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] cachedBytes;
        byte[] byArray = cachedBytes = this.cache == null ? null : this.cache.get();
        if (cachedBytes != null) {
            return new ByteArrayInputStream(cachedBytes);
        }
        InputStream cached = this.tryCache();
        if (cached != null) {
            return cached;
        }
        return this.delegate.getInputStream();
    }

    private synchronized InputStream tryCache() throws IOException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (InputStream input = this.delegate.getInputStream();){
                input.transferTo(output);
            }
            byte[] bytes = output.toByteArray();
            this.cache = new SoftReference<byte[]>(bytes);
            return new ByteArrayInputStream(bytes);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    @Override
    public long getContentLength() {
        return 0L;
    }
}

