/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs.dir;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.enfs.dir.FileEntry;

public final class Directory
extends FileEntry {
    private final Map<String, FileEntry> map = new ConcurrentHashMap<String, FileEntry>();

    @Override
    public final InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getContentLength() {
        return 0L;
    }

    public final FileEntry find(Path path) {
        Directory current;
        if (path == null) {
            return this;
        }
        FileEntry result = current = this;
        boolean endMode = false;
        for (Path p : path) {
            if (endMode) {
                return result;
            }
            FileEntry entry = current.get(p.toString());
            if (entry == null) {
                return null;
            }
            if (entry instanceof Directory) {
                current = (Directory)entry;
            } else {
                endMode = true;
            }
            result = entry;
        }
        return result;
    }

    public final FileEntry get(String name) {
        return this.map.get(name);
    }

    public final FileEntry delete(String name) {
        return this.map.remove(name);
    }

    public final void add(String name, FileEntry entry) {
        this.map.put(name, entry);
    }

    public final void clear() {
        this.map.clear();
    }

    public final void printAll() {
        this.printAll(0, "", this.map);
    }

    private void printAll(int n, String base, Map<String, FileEntry> map) {
        map.forEach((k, v) -> {
            if (v instanceof Directory) {
                this.printAll(n + 1, base.concat("/").concat((String)k), ((Directory)v).map);
            } else {
                System.out.println(String.valueOf(n).concat(base).concat("/").concat((String)k));
            }
        });
    }
}

