/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs.dir;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pro.gravit.utils.enfs.dir.FileEntry;

public class RealFile
extends FileEntry {
    private final Path file;

    public RealFile(Path file) {
        this.file = file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public long getContentLength() {
        try {
            return Files.size(this.file);
        }
        catch (IOException e) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public URLConnection openConnection(URL url) {
        try {
            return this.file.toUri().toURL().openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

